# -*- coding: utf-8 -*-
"""Opencv.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1SscPDOCKlSlB3KPafX0O78W8oVH-bgkx
"""

!pip install zipfile
!pip install pandas
!pip install python-docx
!pip install llama-index-embeddings-huggingface
!pip install llama-index-embeddings-instructor
!pip install chromadb
!pip install llama-index
!pip install transformers
!pip install torch

import zipfile
import pandas as pd
import os

data = zipfile.ZipFile('/content/Al Nassar Club_data corpus-20241106T131026Z-001.zip')
os.mkdir('/content/data')
data.extractall('/content/data')

import chromadb as chdb
from chromadb.utils import embedding_functions
chroma = chdb.PersistentClient(path="chroma_db_files")
collection_name = "Rag_using_HuggingFace_Embeddings"
collection = chroma.create_collection(name=collection_name)

def split_text_into_chunks(text, chunk_size=1000, chunk_overlap=20):
  chunks = []
  start = 0
  while start < len(text):
    end = start + chunk_size
    chunks.append(text[start:end])
    start = end
  return chunks

import os
from collections import defaultdict

def count_file_extensions(directory):
    extension_count = defaultdict(int)  # Dictionary to store counts of each file extension

    # Walk through all files in the directory and subdirectories
    for root, _, files in os.walk(directory):
        for file in files:
            # Split the file extension
            _, ext = os.path.splitext(file)
            ext = ext.lower()  # Convert to lowercase for uniformity
            extension_count[ext] += 1  # Increment count for this extension

    # Display results
    for ext, count in extension_count.items():
        print(f"{ext or 'No Extension'}: {count} files")

# Example usage
directory_path = '/content/data/Al Nassar Club_data corpus'  # Replace with your directory path
count_file_extensions(directory_path)

import os
import json
import pandas as pd
from docx import Document

# Function to read and process text files
def read_txt(file_path):
    with open(file_path, 'r') as file:
        return file.read()

# Function to read and process docx files
def read_docx(file_path):
    doc = Document(file_path)
    return "\n".join([para.text for para in doc.paragraphs])

# Function to read and process json files
def read_json(file_path):
    with open(file_path, 'r') as file:
        data = json.load(file)
        return json.dumps(data)  # Convert JSON data to string for processing

# Function to read and process csv files
def read_csv(file_path):
    # Specify the encoding as 'latin-1' when reading the CSV file
    df = pd.read_csv(file_path, encoding='latin-1')
    return df.to_string()  # Convert DataFrame to string for processing

# Function to handle all files and split them into chunks
def process_directory(directory):
    combined_text = ""

    for filename in os.listdir(directory):
        file_path = os.path.join(directory, filename)

        if filename.endswith('.txt'):
            combined_text += read_txt(file_path)
        elif filename.endswith('.docx'):
            combined_text += read_docx(file_path)
        elif filename.endswith('.json'):
            combined_text += read_json(file_path)
        elif filename.endswith('.csv'):
            combined_text += read_csv(file_path)

    # Split the combined text into chunks
    chunked_data = split_text_into_chunks(combined_text)
    print(f"Total chunks: {len(chunked_data)}")
    return chunked_data

# Process the directory
directory = '/content/data/Al Nassar Club_data corpus'
chunked_data = process_directory(directory)



from llama_index.embeddings.huggingface import HuggingFaceEmbedding
embed_model = HuggingFaceEmbedding(model_name="BAAI/bge-base-en-v1.5")

embeddings = embed_model.get_text_embedding_batch(chunked_data)
print(len(embeddings))
print(embeddings[:5])

ids = [f"chunk-{i}" for i in range(len(chunked_data))]
collection.upsert(
    documents=chunked_data,
    metadatas=None,
    embeddings=embeddings,
    ids=ids  # Use the generated IDs
)
from multiprocessing import context
def query_collection(query_text, n_results=2, top_k=3):
    query_embedding = embed_model.get_text_embedding(query_text)
    results = collection.query(
        query_embeddings=[query_embedding],
        n_results=n_results
    )
    return results

query_collection(" Al Nassr was officially established on March 24, 1955, in Riyadh, Saudi Arabia." , n_results=1)

# Assuming your collection is already created and you have the embeddings
for idx, embedding in enumerate(embeddings):
    collection.add(
        ids=[f"doc_{idx}"],  # Unique document ID
        embeddings=[embedding],  # The embedding vector
        metadatas=[{"source": "source_name"}],  # Optional metadata
        documents=[chunked_data[idx]]  # Corresponding document/text
    )

print("Embeddings saved to Chroma collection.")

import pandas as pd

# Assuming embeddings is a 2D list or array
embedding_filename = '/content/data/embeddings.csv'
df = pd.DataFrame(embeddings)

# Save as CSV
df.to_csv(embedding_filename, index=False)

print(f"Embeddings saved to {embedding_filename}")

import shutil

# Specify the directory to zip
directory_to_zip = '/content/chroma_db_files'
# Specify the path for the resulting zip file (without the extension)
zip_filename = '/content/Chroma'

# Create a zip archive of the directory
shutil.make_archive(zip_filename, 'zip', directory_to_zip)

print(f"Directory zipped and saved as {zip_filename}.zip")

def generate_answer(query, retrieved_docs):
    tokenizer.pad_token = tokenizer.eos_token

    flattened_docs = [doc for sublist in retrieved_docs for doc in sublist]
    prompt = query + "\n" + " ".join(flattened_docs)

    inputs = tokenizer(prompt, return_tensors="pt", max_length=1024, truncation=True, padding=True)

    outputs = model.generate(
        inputs["input_ids"],
        attention_mask=inputs["attention_mask"],
        pad_token_id=tokenizer.eos_token_id,
        max_new_tokens=150,
        num_return_sequences=1,
        no_repeat_ngram_size=2
    )

    return tokenizer.decode(outputs[0], skip_special_tokens=True)

query = "Write me a poem about Al Nassr, the pride of Saudi football."
retrieved_docs = query_collection(query)
answer = generate_answer(query, retrieved_docs)

print(answer)